package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeauthorizeDataShareRequest(
    dataShareArn: String,
    consumerIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest = {
    import DeauthorizeDataShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest
      .builder()
      .dataShareArn(dataShareArn: java.lang.String)
      .consumerIdentifier(consumerIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeauthorizeDataShareRequest.ReadOnly =
    zio.aws.redshift.model.DeauthorizeDataShareRequest.wrap(buildAwsValue())
}
object DeauthorizeDataShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeauthorizeDataShareRequest =
      zio.aws.redshift.model
        .DeauthorizeDataShareRequest(dataShareArn, consumerIdentifier)
    def dataShareArn: String
    def consumerIdentifier: String
    def getDataShareArn: ZIO[Any, Nothing, String] = ZIO.succeed(dataShareArn)
    def getConsumerIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(consumerIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest
  ) extends zio.aws.redshift.model.DeauthorizeDataShareRequest.ReadOnly {
    override val dataShareArn: String = impl.dataShareArn(): String
    override val consumerIdentifier: String = impl.consumerIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest
  ): zio.aws.redshift.model.DeauthorizeDataShareRequest.ReadOnly = new Wrapper(
    impl
  )
}
