package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait ScheduledActionFilterName {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName
}
object ScheduledActionFilterName {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName
  ): zio.aws.redshift.model.ScheduledActionFilterName = value match {
    case software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName.CLUSTER_IDENTIFIER =>
      val r = `cluster-identifier`
      r
    case software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName.IAM_ROLE =>
      val r = `iam-role`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.ScheduledActionFilterName {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName =
      software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `cluster-identifier`
      extends zio.aws.redshift.model.ScheduledActionFilterName {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName =
      software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName.CLUSTER_IDENTIFIER
  }
  case object `iam-role`
      extends zio.aws.redshift.model.ScheduledActionFilterName {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName =
      software.amazon.awssdk.services.redshift.model.ScheduledActionFilterName.IAM_ROLE
  }
}
