package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccountAttribute(
    attributeName: Optional[String] = Optional.Absent,
    attributeValues: Optional[
      Iterable[zio.aws.redshift.model.AttributeValueTarget]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AccountAttribute = {
    import AccountAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AccountAttribute
      .builder()
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(
        attributeValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeValues)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AccountAttribute.ReadOnly =
    zio.aws.redshift.model.AccountAttribute.wrap(buildAwsValue())
}
object AccountAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AccountAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AccountAttribute =
      zio.aws.redshift.model.AccountAttribute(
        attributeName.map(value => value),
        attributeValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributeName: Optional[String]
    def attributeValues
        : Optional[List[zio.aws.redshift.model.AttributeValueTarget.ReadOnly]]
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValues: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.AttributeValueTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeValues", attributeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AccountAttribute
  ) extends zio.aws.redshift.model.AccountAttribute.ReadOnly {
    override val attributeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => value: String)
    override val attributeValues
        : Optional[List[zio.aws.redshift.model.AttributeValueTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.AttributeValueTarget.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AccountAttribute
  ): zio.aws.redshift.model.AccountAttribute.ReadOnly = new Wrapper(impl)
}
