package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResumeClusterRequest(clusterIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResumeClusterRequest = {
    import ResumeClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResumeClusterRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ResumeClusterRequest.ReadOnly =
    zio.aws.redshift.model.ResumeClusterRequest.wrap(buildAwsValue())
}
object ResumeClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResumeClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResumeClusterRequest =
      zio.aws.redshift.model.ResumeClusterRequest(clusterIdentifier)
    def clusterIdentifier: String
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResumeClusterRequest
  ) extends zio.aws.redshift.model.ResumeClusterRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResumeClusterRequest
  ): zio.aws.redshift.model.ResumeClusterRequest.ReadOnly = new Wrapper(impl)
}
