package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ScheduledActionType(
    resizeCluster: Option[zio.aws.redshift.model.ResizeClusterMessage] = None,
    pauseCluster: Option[zio.aws.redshift.model.PauseClusterMessage] = None,
    resumeCluster: Option[zio.aws.redshift.model.ResumeClusterMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ScheduledActionType = {
    import ScheduledActionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ScheduledActionType
      .builder()
      .optionallyWith(resizeCluster.map(value => value.buildAwsValue()))(
        _.resizeCluster
      )
      .optionallyWith(pauseCluster.map(value => value.buildAwsValue()))(
        _.pauseCluster
      )
      .optionallyWith(resumeCluster.map(value => value.buildAwsValue()))(
        _.resumeCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ScheduledActionType.ReadOnly =
    zio.aws.redshift.model.ScheduledActionType.wrap(buildAwsValue())
}
object ScheduledActionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ScheduledActionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ScheduledActionType =
      zio.aws.redshift.model.ScheduledActionType(
        resizeCluster.map(value => value.asEditable),
        pauseCluster.map(value => value.asEditable),
        resumeCluster.map(value => value.asEditable)
      )
    def resizeCluster
        : Option[zio.aws.redshift.model.ResizeClusterMessage.ReadOnly]
    def pauseCluster
        : Option[zio.aws.redshift.model.PauseClusterMessage.ReadOnly]
    def resumeCluster
        : Option[zio.aws.redshift.model.ResumeClusterMessage.ReadOnly]
    def getResizeCluster: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ResizeClusterMessage.ReadOnly
    ] = AwsError.unwrapOptionField("resizeCluster", resizeCluster)
    def getPauseCluster: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.PauseClusterMessage.ReadOnly
    ] = AwsError.unwrapOptionField("pauseCluster", pauseCluster)
    def getResumeCluster: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ResumeClusterMessage.ReadOnly
    ] = AwsError.unwrapOptionField("resumeCluster", resumeCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ScheduledActionType
  ) extends zio.aws.redshift.model.ScheduledActionType.ReadOnly {
    override val resizeCluster
        : Option[zio.aws.redshift.model.ResizeClusterMessage.ReadOnly] = scala
      .Option(impl.resizeCluster())
      .map(value => zio.aws.redshift.model.ResizeClusterMessage.wrap(value))
    override val pauseCluster
        : Option[zio.aws.redshift.model.PauseClusterMessage.ReadOnly] = scala
      .Option(impl.pauseCluster())
      .map(value => zio.aws.redshift.model.PauseClusterMessage.wrap(value))
    override val resumeCluster
        : Option[zio.aws.redshift.model.ResumeClusterMessage.ReadOnly] = scala
      .Option(impl.resumeCluster())
      .map(value => zio.aws.redshift.model.ResumeClusterMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ScheduledActionType
  ): zio.aws.redshift.model.ScheduledActionType.ReadOnly = new Wrapper(impl)
}
