package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RevokeSnapshotAccessResponse(
    snapshot: Option[zio.aws.redshift.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse = {
    import RevokeSnapshotAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RevokeSnapshotAccessResponse.ReadOnly =
    zio.aws.redshift.model.RevokeSnapshotAccessResponse.wrap(buildAwsValue())
}
object RevokeSnapshotAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RevokeSnapshotAccessResponse =
      zio.aws.redshift.model
        .RevokeSnapshotAccessResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.redshift.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse
  ) extends zio.aws.redshift.model.RevokeSnapshotAccessResponse.ReadOnly {
    override val snapshot: Option[zio.aws.redshift.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value => zio.aws.redshift.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse
  ): zio.aws.redshift.model.RevokeSnapshotAccessResponse.ReadOnly = new Wrapper(
    impl
  )
}
