package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.LongOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyUsageLimitRequest(
    usageLimitId: String,
    amount: Option[LongOptional] = None,
    breachAction: Option[zio.aws.redshift.model.UsageLimitBreachAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest = {
    import ModifyUsageLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest
      .builder()
      .usageLimitId(usageLimitId: java.lang.String)
      .optionallyWith(amount.map(value => value: java.lang.Long))(_.amount)
      .optionallyWith(breachAction.map(value => value.unwrap))(_.breachAction)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyUsageLimitRequest.ReadOnly =
    zio.aws.redshift.model.ModifyUsageLimitRequest.wrap(buildAwsValue())
}
object ModifyUsageLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyUsageLimitRequest =
      zio.aws.redshift.model.ModifyUsageLimitRequest(
        usageLimitId,
        amount.map(value => value),
        breachAction.map(value => value)
      )
    def usageLimitId: String
    def amount: Option[LongOptional]
    def breachAction: Option[zio.aws.redshift.model.UsageLimitBreachAction]
    def getUsageLimitId: ZIO[Any, Nothing, String] = ZIO.succeed(usageLimitId)
    def getAmount: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("amount", amount)
    def getBreachAction
        : ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitBreachAction] =
      AwsError.unwrapOptionField("breachAction", breachAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest
  ) extends zio.aws.redshift.model.ModifyUsageLimitRequest.ReadOnly {
    override val usageLimitId: String = impl.usageLimitId(): String
    override val amount: Option[LongOptional] =
      scala.Option(impl.amount()).map(value => value: LongOptional)
    override val breachAction
        : Option[zio.aws.redshift.model.UsageLimitBreachAction] = scala
      .Option(impl.breachAction())
      .map(value => zio.aws.redshift.model.UsageLimitBreachAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest
  ): zio.aws.redshift.model.ModifyUsageLimitRequest.ReadOnly = new Wrapper(impl)
}
