package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyClusterSnapshotResponse(
    snapshot: Option[zio.aws.redshift.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse = {
    import ModifyClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterSnapshotResponse.ReadOnly =
    zio.aws.redshift.model.ModifyClusterSnapshotResponse.wrap(buildAwsValue())
}
object ModifyClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterSnapshotResponse =
      zio.aws.redshift.model
        .ModifyClusterSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.redshift.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse
  ) extends zio.aws.redshift.model.ModifyClusterSnapshotResponse.ReadOnly {
    override val snapshot: Option[zio.aws.redshift.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value => zio.aws.redshift.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse
  ): zio.aws.redshift.model.ModifyClusterSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
