package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HsmStatus(
    hsmClientCertificateIdentifier: Option[String] = None,
    hsmConfigurationIdentifier: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.HsmStatus = {
    import HsmStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.HsmStatus
      .builder()
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.HsmStatus.ReadOnly =
    zio.aws.redshift.model.HsmStatus.wrap(buildAwsValue())
}
object HsmStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.HsmStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.HsmStatus =
      zio.aws.redshift.model.HsmStatus(
        hsmClientCertificateIdentifier.map(value => value),
        hsmConfigurationIdentifier.map(value => value),
        status.map(value => value)
      )
    def hsmClientCertificateIdentifier: Option[String]
    def hsmConfigurationIdentifier: Option[String]
    def status: Option[String]
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.HsmStatus
  ) extends zio.aws.redshift.model.HsmStatus.ReadOnly {
    override val hsmClientCertificateIdentifier: Option[String] = scala
      .Option(impl.hsmClientCertificateIdentifier())
      .map(value => value: String)
    override val hsmConfigurationIdentifier: Option[String] = scala
      .Option(impl.hsmConfigurationIdentifier())
      .map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.HsmStatus
  ): zio.aws.redshift.model.HsmStatus.ReadOnly = new Wrapper(impl)
}
