package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeUsageLimitsRequest(
    usageLimitId: Option[String] = None,
    clusterIdentifier: Option[String] = None,
    featureType: Option[zio.aws.redshift.model.UsageLimitFeatureType] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    tagKeys: Option[Iterable[String]] = None,
    tagValues: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest = {
    import DescribeUsageLimitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest
      .builder()
      .optionallyWith(usageLimitId.map(value => value: java.lang.String))(
        _.usageLimitId
      )
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(featureType.map(value => value.unwrap))(_.featureType)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeUsageLimitsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeUsageLimitsRequest.wrap(buildAwsValue())
}
object DescribeUsageLimitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeUsageLimitsRequest =
      zio.aws.redshift.model.DescribeUsageLimitsRequest(
        usageLimitId.map(value => value),
        clusterIdentifier.map(value => value),
        featureType.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value)
      )
    def usageLimitId: Option[String]
    def clusterIdentifier: Option[String]
    def featureType: Option[zio.aws.redshift.model.UsageLimitFeatureType]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def tagKeys: Option[List[String]]
    def tagValues: Option[List[String]]
    def getUsageLimitId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageLimitId", usageLimitId)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getFeatureType
        : ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitFeatureType] =
      AwsError.unwrapOptionField("featureType", featureType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest
  ) extends zio.aws.redshift.model.DescribeUsageLimitsRequest.ReadOnly {
    override val usageLimitId: Option[String] =
      scala.Option(impl.usageLimitId()).map(value => value: String)
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val featureType
        : Option[zio.aws.redshift.model.UsageLimitFeatureType] = scala
      .Option(impl.featureType())
      .map(value => zio.aws.redshift.model.UsageLimitFeatureType.wrap(value))
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Option[List[String]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest
  ): zio.aws.redshift.model.DescribeUsageLimitsRequest.ReadOnly = new Wrapper(
    impl
  )
}
