package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeReservedNodeExchangeStatusRequest(
    reservedNodeId: Option[String] = None,
    reservedNodeExchangeRequestId: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest = {
    import DescribeReservedNodeExchangeStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
      .builder()
      .optionallyWith(reservedNodeId.map(value => value: java.lang.String))(
        _.reservedNodeId
      )
      .optionallyWith(
        reservedNodeExchangeRequestId.map(value => value: java.lang.String)
      )(_.reservedNodeExchangeRequestId)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest.ReadOnly =
    zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest
      .wrap(buildAwsValue())
}
object DescribeReservedNodeExchangeStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest =
      zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest(
        reservedNodeId.map(value => value),
        reservedNodeExchangeRequestId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedNodeId: Option[String]
    def reservedNodeExchangeRequestId: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedNodeId", reservedNodeId)
    def getReservedNodeExchangeRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedNodeExchangeRequestId",
        reservedNodeExchangeRequestId
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
  ) extends zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest.ReadOnly {
    override val reservedNodeId: Option[String] =
      scala.Option(impl.reservedNodeId()).map(value => value: String)
    override val reservedNodeExchangeRequestId: Option[String] = scala
      .Option(impl.reservedNodeExchangeRequestId())
      .map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
  ): zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest.ReadOnly =
    new Wrapper(impl)
}
