package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetReservedNodeExchangeConfigurationOptionsResponse(
    marker: Option[String] = None,
    reservedNodeConfigurationOptionList: Option[
      Iterable[zio.aws.redshift.model.ReservedNodeConfigurationOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse = {
    import GetReservedNodeExchangeConfigurationOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedNodeConfigurationOptionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedNodeConfigurationOptionList)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.ReadOnly =
    zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse
      .wrap(buildAwsValue())
}
object GetReservedNodeExchangeConfigurationOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse =
      zio.aws.redshift.model
        .GetReservedNodeExchangeConfigurationOptionsResponse(
          marker.map(value => value),
          reservedNodeConfigurationOptionList.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def marker: Option[String]
    def reservedNodeConfigurationOptionList: Option[
      List[zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedNodeConfigurationOptionList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedNodeConfigurationOptionList",
      reservedNodeConfigurationOptionList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse
  ) extends zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val reservedNodeConfigurationOptionList: Option[
      List[zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly]
    ] = scala
      .Option(impl.reservedNodeConfigurationOptionList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ReservedNodeConfigurationOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse
  ): zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
