package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EventSubscription(
    customerAwsId: Option[String] = None,
    custSubscriptionId: Option[String] = None,
    snsTopicArn: Option[String] = None,
    status: Option[String] = None,
    subscriptionCreationTime: Option[TStamp] = None,
    sourceType: Option[String] = None,
    sourceIdsList: Option[Iterable[String]] = None,
    eventCategoriesList: Option[Iterable[String]] = None,
    severity: Option[String] = None,
    enabled: Option[Boolean] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EventSubscription = {
    import EventSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EventSubscription
      .builder()
      .optionallyWith(customerAwsId.map(value => value: java.lang.String))(
        _.customerAwsId
      )
      .optionallyWith(custSubscriptionId.map(value => value: java.lang.String))(
        _.custSubscriptionId
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        subscriptionCreationTime.map(value => TStamp.unwrap(value): Instant)
      )(_.subscriptionCreationTime)
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        sourceIdsList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIdsList)
      .optionallyWith(
        eventCategoriesList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategoriesList)
      .optionallyWith(severity.map(value => value: java.lang.String))(
        _.severity
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EventSubscription.ReadOnly =
    zio.aws.redshift.model.EventSubscription.wrap(buildAwsValue())
}
object EventSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EventSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EventSubscription =
      zio.aws.redshift.model.EventSubscription(
        customerAwsId.map(value => value),
        custSubscriptionId.map(value => value),
        snsTopicArn.map(value => value),
        status.map(value => value),
        subscriptionCreationTime.map(value => value),
        sourceType.map(value => value),
        sourceIdsList.map(value => value),
        eventCategoriesList.map(value => value),
        severity.map(value => value),
        enabled.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customerAwsId: Option[String]
    def custSubscriptionId: Option[String]
    def snsTopicArn: Option[String]
    def status: Option[String]
    def subscriptionCreationTime: Option[TStamp]
    def sourceType: Option[String]
    def sourceIdsList: Option[List[String]]
    def eventCategoriesList: Option[List[String]]
    def severity: Option[String]
    def enabled: Option[Boolean]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getCustomerAwsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerAwsId", customerAwsId)
    def getCustSubscriptionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionId)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSubscriptionCreationTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("subscriptionCreationTime", subscriptionCreationTime)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceIdsList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIdsList", sourceIdsList)
    def getEventCategoriesList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesList)
    def getSeverity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("severity", severity)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EventSubscription
  ) extends zio.aws.redshift.model.EventSubscription.ReadOnly {
    override val customerAwsId: Option[String] =
      scala.Option(impl.customerAwsId()).map(value => value: String)
    override val custSubscriptionId: Option[String] =
      scala.Option(impl.custSubscriptionId()).map(value => value: String)
    override val snsTopicArn: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val subscriptionCreationTime: Option[TStamp] = scala
      .Option(impl.subscriptionCreationTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val sourceIdsList: Option[List[String]] = scala
      .Option(impl.sourceIdsList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eventCategoriesList: Option[List[String]] = scala
      .Option(impl.eventCategoriesList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val severity: Option[String] =
      scala.Option(impl.severity()).map(value => value: String)
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EventSubscription
  ): zio.aws.redshift.model.EventSubscription.ReadOnly = new Wrapper(impl)
}
