package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeNodeConfigurationOptionsResponse(
    nodeConfigurationOptionList: Option[
      Iterable[zio.aws.redshift.model.NodeConfigurationOption]
    ] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse = {
    import DescribeNodeConfigurationOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse
      .builder()
      .optionallyWith(
        nodeConfigurationOptionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeConfigurationOptionList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse
      .wrap(buildAwsValue())
}
object DescribeNodeConfigurationOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse =
      zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse(
        nodeConfigurationOptionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def nodeConfigurationOptionList
        : Option[List[zio.aws.redshift.model.NodeConfigurationOption.ReadOnly]]
    def marker: Option[String]
    def getNodeConfigurationOptionList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.NodeConfigurationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "nodeConfigurationOptionList",
      nodeConfigurationOptionList
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse
  ) extends zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly {
    override val nodeConfigurationOptionList: Option[
      List[zio.aws.redshift.model.NodeConfigurationOption.ReadOnly]
    ] = scala
      .Option(impl.nodeConfigurationOptionList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.NodeConfigurationOption.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse
  ): zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
