package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyClusterParameterGroupResponse(
    parameterGroupName: Option[String] = None,
    parameterGroupStatus: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse = {
    import ModifyClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterGroupStatus.map(value => value: java.lang.String)
      )(_.parameterGroupStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterParameterGroupResponse.ReadOnly =
    zio.aws.redshift.model.ModifyClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object ModifyClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterParameterGroupResponse =
      zio.aws.redshift.model.ModifyClusterParameterGroupResponse(
        parameterGroupName.map(value => value),
        parameterGroupStatus.map(value => value)
      )
    def parameterGroupName: Option[String]
    def parameterGroupStatus: Option[String]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupStatus", parameterGroupStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse
  ) extends zio.aws.redshift.model.ModifyClusterParameterGroupResponse.ReadOnly {
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val parameterGroupStatus: Option[String] =
      scala.Option(impl.parameterGroupStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse
  ): zio.aws.redshift.model.ModifyClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
