package zio.aws.redshift.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  TStamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeClusterSnapshotsRequest(
    clusterIdentifier: Option[String] = None,
    snapshotIdentifier: Option[String] = None,
    snapshotType: Option[String] = None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    ownerAccount: Option[String] = None,
    tagKeys: Option[Iterable[String]] = None,
    tagValues: Option[Iterable[String]] = None,
    clusterExists: Option[BooleanOptional] = None,
    sortingEntities: Option[
      Iterable[zio.aws.redshift.model.SnapshotSortingEntity]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest = {
    import DescribeClusterSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .optionallyWith(clusterExists.map(value => value: java.lang.Boolean))(
        _.clusterExists
      )
      .optionallyWith(
        sortingEntities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortingEntities)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterSnapshotsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeClusterSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeClusterSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterSnapshotsRequest =
      zio.aws.redshift.model.DescribeClusterSnapshotsRequest(
        clusterIdentifier.map(value => value),
        snapshotIdentifier.map(value => value),
        snapshotType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        ownerAccount.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value),
        clusterExists.map(value => value),
        sortingEntities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterIdentifier: Option[String]
    def snapshotIdentifier: Option[String]
    def snapshotType: Option[String]
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def ownerAccount: Option[String]
    def tagKeys: Option[List[String]]
    def tagValues: Option[List[String]]
    def clusterExists: Option[BooleanOptional]
    def sortingEntities
        : Option[List[zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly]]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
    def getClusterExists: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("clusterExists", clusterExists)
    def getSortingEntities: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("sortingEntities", sortingEntities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest
  ) extends zio.aws.redshift.model.DescribeClusterSnapshotsRequest.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val snapshotIdentifier: Option[String] =
      scala.Option(impl.snapshotIdentifier()).map(value => value: String)
    override val snapshotType: Option[String] =
      scala.Option(impl.snapshotType()).map(value => value: String)
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val ownerAccount: Option[String] =
      scala.Option(impl.ownerAccount()).map(value => value: String)
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Option[List[String]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val clusterExists: Option[BooleanOptional] =
      scala.Option(impl.clusterExists()).map(value => value: BooleanOptional)
    override val sortingEntities
        : Option[List[zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly]] =
      scala
        .Option(impl.sortingEntities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.SnapshotSortingEntity.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest
  ): zio.aws.redshift.model.DescribeClusterSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
