package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteHsmConfigurationRequest(
    hsmConfigurationIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest = {
    import DeleteHsmConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest
      .builder()
      .hsmConfigurationIdentifier(hsmConfigurationIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DeleteHsmConfigurationRequest.ReadOnly =
    zio.aws.redshift.model.DeleteHsmConfigurationRequest.wrap(buildAwsValue())
}
object DeleteHsmConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteHsmConfigurationRequest =
      zio.aws.redshift.model
        .DeleteHsmConfigurationRequest(hsmConfigurationIdentifier)
    def hsmConfigurationIdentifier: String
    def getHsmConfigurationIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(hsmConfigurationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest
  ) extends zio.aws.redshift.model.DeleteHsmConfigurationRequest.ReadOnly {
    override val hsmConfigurationIdentifier: String =
      impl.hsmConfigurationIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest
  ): zio.aws.redshift.model.DeleteHsmConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
