package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteClusterSnapshotRequest(
    snapshotIdentifier: String,
    snapshotClusterIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest = {
    import DeleteClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest
      .builder()
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeleteClusterSnapshotRequest.ReadOnly =
    zio.aws.redshift.model.DeleteClusterSnapshotRequest.wrap(buildAwsValue())
}
object DeleteClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteClusterSnapshotRequest =
      zio.aws.redshift.model.DeleteClusterSnapshotRequest(
        snapshotIdentifier,
        snapshotClusterIdentifier.map(value => value)
      )
    def snapshotIdentifier: String
    def snapshotClusterIdentifier: Option[String]
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest
  ) extends zio.aws.redshift.model.DeleteClusterSnapshotRequest.ReadOnly {
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val snapshotClusterIdentifier: Option[String] =
      scala.Option(impl.snapshotClusterIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest
  ): zio.aws.redshift.model.DeleteClusterSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
