package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreStatus(
    status: Option[String] = None,
    currentRestoreRateInMegaBytesPerSecond: Option[Double] = None,
    snapshotSizeInMegaBytes: Option[Long] = None,
    progressInMegaBytes: Option[Long] = None,
    elapsedTimeInSeconds: Option[Long] = None,
    estimatedTimeToCompletionInSeconds: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RestoreStatus = {
    import RestoreStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RestoreStatus
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        currentRestoreRateInMegaBytesPerSecond.map(value =>
          value: java.lang.Double
        )
      )(_.currentRestoreRateInMegaBytesPerSecond)
      .optionallyWith(
        snapshotSizeInMegaBytes.map(value => value: java.lang.Long)
      )(_.snapshotSizeInMegaBytes)
      .optionallyWith(progressInMegaBytes.map(value => value: java.lang.Long))(
        _.progressInMegaBytes
      )
      .optionallyWith(elapsedTimeInSeconds.map(value => value: java.lang.Long))(
        _.elapsedTimeInSeconds
      )
      .optionallyWith(
        estimatedTimeToCompletionInSeconds.map(value => value: java.lang.Long)
      )(_.estimatedTimeToCompletionInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RestoreStatus.ReadOnly =
    zio.aws.redshift.model.RestoreStatus.wrap(buildAwsValue())
}
object RestoreStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RestoreStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RestoreStatus =
      zio.aws.redshift.model.RestoreStatus(
        status.map(value => value),
        currentRestoreRateInMegaBytesPerSecond.map(value => value),
        snapshotSizeInMegaBytes.map(value => value),
        progressInMegaBytes.map(value => value),
        elapsedTimeInSeconds.map(value => value),
        estimatedTimeToCompletionInSeconds.map(value => value)
      )
    def status: Option[String]
    def currentRestoreRateInMegaBytesPerSecond: Option[Double]
    def snapshotSizeInMegaBytes: Option[Long]
    def progressInMegaBytes: Option[Long]
    def elapsedTimeInSeconds: Option[Long]
    def estimatedTimeToCompletionInSeconds: Option[Long]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCurrentRestoreRateInMegaBytesPerSecond: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "currentRestoreRateInMegaBytesPerSecond",
        currentRestoreRateInMegaBytesPerSecond
      )
    def getSnapshotSizeInMegaBytes: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("snapshotSizeInMegaBytes", snapshotSizeInMegaBytes)
    def getProgressInMegaBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("progressInMegaBytes", progressInMegaBytes)
    def getElapsedTimeInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("elapsedTimeInSeconds", elapsedTimeInSeconds)
    def getEstimatedTimeToCompletionInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeToCompletionInSeconds",
        estimatedTimeToCompletionInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RestoreStatus
  ) extends zio.aws.redshift.model.RestoreStatus.ReadOnly {
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val currentRestoreRateInMegaBytesPerSecond: Option[Double] = scala
      .Option(impl.currentRestoreRateInMegaBytesPerSecond())
      .map(value => value: Double)
    override val snapshotSizeInMegaBytes: Option[Long] =
      scala.Option(impl.snapshotSizeInMegaBytes()).map(value => value: Long)
    override val progressInMegaBytes: Option[Long] =
      scala.Option(impl.progressInMegaBytes()).map(value => value: Long)
    override val elapsedTimeInSeconds: Option[Long] =
      scala.Option(impl.elapsedTimeInSeconds()).map(value => value: Long)
    override val estimatedTimeToCompletionInSeconds: Option[Long] = scala
      .Option(impl.estimatedTimeToCompletionInSeconds())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RestoreStatus
  ): zio.aws.redshift.model.RestoreStatus.ReadOnly = new Wrapper(impl)
}
