package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateEndpointAccessRequest(
    clusterIdentifier: Option[String] = None,
    resourceOwner: Option[String] = None,
    endpointName: String,
    subnetGroupName: String,
    vpcSecurityGroupIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest = {
    import CreateEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .endpointName(endpointName: java.lang.String)
      .subnetGroupName(subnetGroupName: java.lang.String)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateEndpointAccessRequest.ReadOnly =
    zio.aws.redshift.model.CreateEndpointAccessRequest.wrap(buildAwsValue())
}
object CreateEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateEndpointAccessRequest =
      zio.aws.redshift.model.CreateEndpointAccessRequest(
        clusterIdentifier.map(value => value),
        resourceOwner.map(value => value),
        endpointName,
        subnetGroupName,
        vpcSecurityGroupIds.map(value => value)
      )
    def clusterIdentifier: Option[String]
    def resourceOwner: Option[String]
    def endpointName: String
    def subnetGroupName: String
    def vpcSecurityGroupIds: Option[List[String]]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
    def getSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subnetGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest
  ) extends zio.aws.redshift.model.CreateEndpointAccessRequest.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val resourceOwner: Option[String] =
      scala.Option(impl.resourceOwner()).map(value => value: String)
    override val endpointName: String = impl.endpointName(): String
    override val subnetGroupName: String = impl.subnetGroupName(): String
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest
  ): zio.aws.redshift.model.CreateEndpointAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
