package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{LongOptional, Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Cluster(
    clusterIdentifier: Option[String] = None,
    nodeType: Option[String] = None,
    clusterStatus: Option[String] = None,
    clusterAvailabilityStatus: Option[String] = None,
    modifyStatus: Option[String] = None,
    masterUsername: Option[String] = None,
    dbName: Option[String] = None,
    endpoint: Option[zio.aws.redshift.model.Endpoint] = None,
    clusterCreateTime: Option[TStamp] = None,
    automatedSnapshotRetentionPeriod: Option[Integer] = None,
    manualSnapshotRetentionPeriod: Option[Integer] = None,
    clusterSecurityGroups: Option[
      Iterable[zio.aws.redshift.model.ClusterSecurityGroupMembership]
    ] = None,
    vpcSecurityGroups: Option[
      Iterable[zio.aws.redshift.model.VpcSecurityGroupMembership]
    ] = None,
    clusterParameterGroups: Option[
      Iterable[zio.aws.redshift.model.ClusterParameterGroupStatus]
    ] = None,
    clusterSubnetGroupName: Option[String] = None,
    vpcId: Option[String] = None,
    availabilityZone: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    pendingModifiedValues: Option[
      zio.aws.redshift.model.PendingModifiedValues
    ] = None,
    clusterVersion: Option[String] = None,
    allowVersionUpgrade: Option[Boolean] = None,
    numberOfNodes: Option[Integer] = None,
    publiclyAccessible: Option[Boolean] = None,
    encrypted: Option[Boolean] = None,
    restoreStatus: Option[zio.aws.redshift.model.RestoreStatus] = None,
    dataTransferProgress: Option[zio.aws.redshift.model.DataTransferProgress] =
      None,
    hsmStatus: Option[zio.aws.redshift.model.HsmStatus] = None,
    clusterSnapshotCopyStatus: Option[
      zio.aws.redshift.model.ClusterSnapshotCopyStatus
    ] = None,
    clusterPublicKey: Option[String] = None,
    clusterNodes: Option[Iterable[zio.aws.redshift.model.ClusterNode]] = None,
    elasticIpStatus: Option[zio.aws.redshift.model.ElasticIpStatus] = None,
    clusterRevisionNumber: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None,
    kmsKeyId: Option[String] = None,
    enhancedVpcRouting: Option[Boolean] = None,
    iamRoles: Option[Iterable[zio.aws.redshift.model.ClusterIamRole]] = None,
    pendingActions: Option[Iterable[String]] = None,
    maintenanceTrackName: Option[String] = None,
    elasticResizeNumberOfNodeOptions: Option[String] = None,
    deferredMaintenanceWindows: Option[
      Iterable[zio.aws.redshift.model.DeferredMaintenanceWindow]
    ] = None,
    snapshotScheduleIdentifier: Option[String] = None,
    snapshotScheduleState: Option[zio.aws.redshift.model.ScheduleState] = None,
    expectedNextSnapshotScheduleTime: Option[TStamp] = None,
    expectedNextSnapshotScheduleTimeStatus: Option[String] = None,
    nextMaintenanceWindowStartTime: Option[TStamp] = None,
    resizeInfo: Option[zio.aws.redshift.model.ResizeInfo] = None,
    availabilityZoneRelocationStatus: Option[String] = None,
    clusterNamespaceArn: Option[String] = None,
    totalStorageCapacityInMegaBytes: Option[LongOptional] = None,
    aquaConfiguration: Option[zio.aws.redshift.model.AquaConfiguration] = None,
    defaultIamRoleArn: Option[String] = None,
    reservedNodeExchangeStatus: Option[
      zio.aws.redshift.model.ReservedNodeExchangeStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Cluster
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(clusterStatus.map(value => value: java.lang.String))(
        _.clusterStatus
      )
      .optionallyWith(
        clusterAvailabilityStatus.map(value => value: java.lang.String)
      )(_.clusterAvailabilityStatus)
      .optionallyWith(modifyStatus.map(value => value: java.lang.String))(
        _.modifyStatus
      )
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(
        clusterParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterParameterGroups)
      .optionallyWith(
        clusterSubnetGroupName.map(value => value: java.lang.String)
      )(_.clusterSubnetGroupName)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(numberOfNodes.map(value => value: java.lang.Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(restoreStatus.map(value => value.buildAwsValue()))(
        _.restoreStatus
      )
      .optionallyWith(dataTransferProgress.map(value => value.buildAwsValue()))(
        _.dataTransferProgress
      )
      .optionallyWith(hsmStatus.map(value => value.buildAwsValue()))(
        _.hsmStatus
      )
      .optionallyWith(
        clusterSnapshotCopyStatus.map(value => value.buildAwsValue())
      )(_.clusterSnapshotCopyStatus)
      .optionallyWith(clusterPublicKey.map(value => value: java.lang.String))(
        _.clusterPublicKey
      )
      .optionallyWith(
        clusterNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterNodes)
      .optionallyWith(elasticIpStatus.map(value => value.buildAwsValue()))(
        _.elasticIpStatus
      )
      .optionallyWith(
        clusterRevisionNumber.map(value => value: java.lang.String)
      )(_.clusterRevisionNumber)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(
        pendingActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.pendingActions)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(
        elasticResizeNumberOfNodeOptions.map(value => value: java.lang.String)
      )(_.elasticResizeNumberOfNodeOptions)
      .optionallyWith(
        deferredMaintenanceWindows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deferredMaintenanceWindows)
      .optionallyWith(
        snapshotScheduleIdentifier.map(value => value: java.lang.String)
      )(_.snapshotScheduleIdentifier)
      .optionallyWith(snapshotScheduleState.map(value => value.unwrap))(
        _.snapshotScheduleState
      )
      .optionallyWith(
        expectedNextSnapshotScheduleTime.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.expectedNextSnapshotScheduleTime)
      .optionallyWith(
        expectedNextSnapshotScheduleTimeStatus.map(value =>
          value: java.lang.String
        )
      )(_.expectedNextSnapshotScheduleTimeStatus)
      .optionallyWith(
        nextMaintenanceWindowStartTime.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.nextMaintenanceWindowStartTime)
      .optionallyWith(resizeInfo.map(value => value.buildAwsValue()))(
        _.resizeInfo
      )
      .optionallyWith(
        availabilityZoneRelocationStatus.map(value => value: java.lang.String)
      )(_.availabilityZoneRelocationStatus)
      .optionallyWith(
        clusterNamespaceArn.map(value => value: java.lang.String)
      )(_.clusterNamespaceArn)
      .optionallyWith(
        totalStorageCapacityInMegaBytes.map(value => value: java.lang.Long)
      )(_.totalStorageCapacityInMegaBytes)
      .optionallyWith(aquaConfiguration.map(value => value.buildAwsValue()))(
        _.aquaConfiguration
      )
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .optionallyWith(
        reservedNodeExchangeStatus.map(value => value.buildAwsValue())
      )(_.reservedNodeExchangeStatus)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Cluster.ReadOnly =
    zio.aws.redshift.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Cluster =
      zio.aws.redshift.model.Cluster(
        clusterIdentifier.map(value => value),
        nodeType.map(value => value),
        clusterStatus.map(value => value),
        clusterAvailabilityStatus.map(value => value),
        modifyStatus.map(value => value),
        masterUsername.map(value => value),
        dbName.map(value => value),
        endpoint.map(value => value.asEditable),
        clusterCreateTime.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterSubnetGroupName.map(value => value),
        vpcId.map(value => value),
        availabilityZone.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        clusterVersion.map(value => value),
        allowVersionUpgrade.map(value => value),
        numberOfNodes.map(value => value),
        publiclyAccessible.map(value => value),
        encrypted.map(value => value),
        restoreStatus.map(value => value.asEditable),
        dataTransferProgress.map(value => value.asEditable),
        hsmStatus.map(value => value.asEditable),
        clusterSnapshotCopyStatus.map(value => value.asEditable),
        clusterPublicKey.map(value => value),
        clusterNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticIpStatus.map(value => value.asEditable),
        clusterRevisionNumber.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enhancedVpcRouting.map(value => value),
        iamRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pendingActions.map(value => value),
        maintenanceTrackName.map(value => value),
        elasticResizeNumberOfNodeOptions.map(value => value),
        deferredMaintenanceWindows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotScheduleIdentifier.map(value => value),
        snapshotScheduleState.map(value => value),
        expectedNextSnapshotScheduleTime.map(value => value),
        expectedNextSnapshotScheduleTimeStatus.map(value => value),
        nextMaintenanceWindowStartTime.map(value => value),
        resizeInfo.map(value => value.asEditable),
        availabilityZoneRelocationStatus.map(value => value),
        clusterNamespaceArn.map(value => value),
        totalStorageCapacityInMegaBytes.map(value => value),
        aquaConfiguration.map(value => value.asEditable),
        defaultIamRoleArn.map(value => value),
        reservedNodeExchangeStatus.map(value => value.asEditable)
      )
    def clusterIdentifier: Option[String]
    def nodeType: Option[String]
    def clusterStatus: Option[String]
    def clusterAvailabilityStatus: Option[String]
    def modifyStatus: Option[String]
    def masterUsername: Option[String]
    def dbName: Option[String]
    def endpoint: Option[zio.aws.redshift.model.Endpoint.ReadOnly]
    def clusterCreateTime: Option[TStamp]
    def automatedSnapshotRetentionPeriod: Option[Integer]
    def manualSnapshotRetentionPeriod: Option[Integer]
    def clusterSecurityGroups: Option[
      List[zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly]
    ]
    def vpcSecurityGroups: Option[
      List[zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def clusterParameterGroups: Option[
      List[zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly]
    ]
    def clusterSubnetGroupName: Option[String]
    def vpcId: Option[String]
    def availabilityZone: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def pendingModifiedValues
        : Option[zio.aws.redshift.model.PendingModifiedValues.ReadOnly]
    def clusterVersion: Option[String]
    def allowVersionUpgrade: Option[Boolean]
    def numberOfNodes: Option[Integer]
    def publiclyAccessible: Option[Boolean]
    def encrypted: Option[Boolean]
    def restoreStatus: Option[zio.aws.redshift.model.RestoreStatus.ReadOnly]
    def dataTransferProgress
        : Option[zio.aws.redshift.model.DataTransferProgress.ReadOnly]
    def hsmStatus: Option[zio.aws.redshift.model.HsmStatus.ReadOnly]
    def clusterSnapshotCopyStatus
        : Option[zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly]
    def clusterPublicKey: Option[String]
    def clusterNodes: Option[List[zio.aws.redshift.model.ClusterNode.ReadOnly]]
    def elasticIpStatus: Option[zio.aws.redshift.model.ElasticIpStatus.ReadOnly]
    def clusterRevisionNumber: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def kmsKeyId: Option[String]
    def enhancedVpcRouting: Option[Boolean]
    def iamRoles: Option[List[zio.aws.redshift.model.ClusterIamRole.ReadOnly]]
    def pendingActions: Option[List[String]]
    def maintenanceTrackName: Option[String]
    def elasticResizeNumberOfNodeOptions: Option[String]
    def deferredMaintenanceWindows: Option[
      List[zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly]
    ]
    def snapshotScheduleIdentifier: Option[String]
    def snapshotScheduleState: Option[zio.aws.redshift.model.ScheduleState]
    def expectedNextSnapshotScheduleTime: Option[TStamp]
    def expectedNextSnapshotScheduleTimeStatus: Option[String]
    def nextMaintenanceWindowStartTime: Option[TStamp]
    def resizeInfo: Option[zio.aws.redshift.model.ResizeInfo.ReadOnly]
    def availabilityZoneRelocationStatus: Option[String]
    def clusterNamespaceArn: Option[String]
    def totalStorageCapacityInMegaBytes: Option[LongOptional]
    def aquaConfiguration
        : Option[zio.aws.redshift.model.AquaConfiguration.ReadOnly]
    def defaultIamRoleArn: Option[String]
    def reservedNodeExchangeStatus
        : Option[zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getClusterStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getClusterAvailabilityStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterAvailabilityStatus", clusterAvailabilityStatus)
    def getModifyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modifyStatus", modifyStatus)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.redshift.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getAutomatedSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "automatedSnapshotRetentionPeriod",
        automatedSnapshotRetentionPeriod
      )
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly
    ]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getClusterParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterParameterGroups",
      clusterParameterGroups
    )
    def getClusterSubnetGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.PendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getAllowVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getRestoreStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.RestoreStatus.ReadOnly] =
      AwsError.unwrapOptionField("restoreStatus", restoreStatus)
    def getDataTransferProgress: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.DataTransferProgress.ReadOnly
    ] = AwsError.unwrapOptionField("dataTransferProgress", dataTransferProgress)
    def getHsmStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.HsmStatus.ReadOnly] =
      AwsError.unwrapOptionField("hsmStatus", hsmStatus)
    def getClusterSnapshotCopyStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clusterSnapshotCopyStatus",
      clusterSnapshotCopyStatus
    )
    def getClusterPublicKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterPublicKey", clusterPublicKey)
    def getClusterNodes: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterNode.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterNodes", clusterNodes)
    def getElasticIpStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.ElasticIpStatus.ReadOnly] =
      AwsError.unwrapOptionField("elasticIpStatus", elasticIpStatus)
    def getClusterRevisionNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterRevisionNumber", clusterRevisionNumber)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getIamRoles: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterIamRole.ReadOnly
    ]] = AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getPendingActions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("pendingActions", pendingActions)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getElasticResizeNumberOfNodeOptions: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "elasticResizeNumberOfNodeOptions",
        elasticResizeNumberOfNodeOptions
      )
    def getDeferredMaintenanceWindows: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "deferredMaintenanceWindows",
      deferredMaintenanceWindows
    )
    def getSnapshotScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "snapshotScheduleIdentifier",
        snapshotScheduleIdentifier
      )
    def getSnapshotScheduleState
        : ZIO[Any, AwsError, zio.aws.redshift.model.ScheduleState] =
      AwsError.unwrapOptionField("snapshotScheduleState", snapshotScheduleState)
    def getExpectedNextSnapshotScheduleTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "expectedNextSnapshotScheduleTime",
        expectedNextSnapshotScheduleTime
      )
    def getExpectedNextSnapshotScheduleTimeStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "expectedNextSnapshotScheduleTimeStatus",
        expectedNextSnapshotScheduleTimeStatus
      )
    def getNextMaintenanceWindowStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "nextMaintenanceWindowStartTime",
        nextMaintenanceWindowStartTime
      )
    def getResizeInfo
        : ZIO[Any, AwsError, zio.aws.redshift.model.ResizeInfo.ReadOnly] =
      AwsError.unwrapOptionField("resizeInfo", resizeInfo)
    def getAvailabilityZoneRelocationStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "availabilityZoneRelocationStatus",
        availabilityZoneRelocationStatus
      )
    def getClusterNamespaceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterNamespaceArn", clusterNamespaceArn)
    def getTotalStorageCapacityInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField(
        "totalStorageCapacityInMegaBytes",
        totalStorageCapacityInMegaBytes
      )
    def getAquaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.AquaConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("aquaConfiguration", aquaConfiguration)
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
    def getReservedNodeExchangeStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "reservedNodeExchangeStatus",
      reservedNodeExchangeStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Cluster
  ) extends zio.aws.redshift.model.Cluster.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val clusterStatus: Option[String] =
      scala.Option(impl.clusterStatus()).map(value => value: String)
    override val clusterAvailabilityStatus: Option[String] =
      scala.Option(impl.clusterAvailabilityStatus()).map(value => value: String)
    override val modifyStatus: Option[String] =
      scala.Option(impl.modifyStatus()).map(value => value: String)
    override val masterUsername: Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val dbName: Option[String] =
      scala.Option(impl.dbName()).map(value => value: String)
    override val endpoint: Option[zio.aws.redshift.model.Endpoint.ReadOnly] =
      scala
        .Option(impl.endpoint())
        .map(value => zio.aws.redshift.model.Endpoint.wrap(value))
    override val clusterCreateTime: Option[TStamp] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val automatedSnapshotRetentionPeriod: Option[Integer] = scala
      .Option(impl.automatedSnapshotRetentionPeriod())
      .map(value => value: Integer)
    override val manualSnapshotRetentionPeriod: Option[Integer] = scala
      .Option(impl.manualSnapshotRetentionPeriod())
      .map(value => value: Integer)
    override val clusterSecurityGroups: Option[
      List[zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.clusterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val vpcSecurityGroups: Option[
      List[zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val clusterParameterGroups: Option[
      List[zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly]
    ] = scala
      .Option(impl.clusterParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterParameterGroupStatus.wrap(item)
        }.toList
      )
    override val clusterSubnetGroupName: Option[String] =
      scala.Option(impl.clusterSubnetGroupName()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val pendingModifiedValues
        : Option[zio.aws.redshift.model.PendingModifiedValues.ReadOnly] = scala
      .Option(impl.pendingModifiedValues())
      .map(value => zio.aws.redshift.model.PendingModifiedValues.wrap(value))
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val allowVersionUpgrade: Option[Boolean] =
      scala.Option(impl.allowVersionUpgrade()).map(value => value: Boolean)
    override val numberOfNodes: Option[Integer] =
      scala.Option(impl.numberOfNodes()).map(value => value: Integer)
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val restoreStatus
        : Option[zio.aws.redshift.model.RestoreStatus.ReadOnly] = scala
      .Option(impl.restoreStatus())
      .map(value => zio.aws.redshift.model.RestoreStatus.wrap(value))
    override val dataTransferProgress
        : Option[zio.aws.redshift.model.DataTransferProgress.ReadOnly] = scala
      .Option(impl.dataTransferProgress())
      .map(value => zio.aws.redshift.model.DataTransferProgress.wrap(value))
    override val hsmStatus: Option[zio.aws.redshift.model.HsmStatus.ReadOnly] =
      scala
        .Option(impl.hsmStatus())
        .map(value => zio.aws.redshift.model.HsmStatus.wrap(value))
    override val clusterSnapshotCopyStatus
        : Option[zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly] =
      scala
        .Option(impl.clusterSnapshotCopyStatus())
        .map(value =>
          zio.aws.redshift.model.ClusterSnapshotCopyStatus.wrap(value)
        )
    override val clusterPublicKey: Option[String] =
      scala.Option(impl.clusterPublicKey()).map(value => value: String)
    override val clusterNodes
        : Option[List[zio.aws.redshift.model.ClusterNode.ReadOnly]] = scala
      .Option(impl.clusterNodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterNode.wrap(item)
        }.toList
      )
    override val elasticIpStatus
        : Option[zio.aws.redshift.model.ElasticIpStatus.ReadOnly] = scala
      .Option(impl.elasticIpStatus())
      .map(value => zio.aws.redshift.model.ElasticIpStatus.wrap(value))
    override val clusterRevisionNumber: Option[String] =
      scala.Option(impl.clusterRevisionNumber()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val enhancedVpcRouting: Option[Boolean] =
      scala.Option(impl.enhancedVpcRouting()).map(value => value: Boolean)
    override val iamRoles
        : Option[List[zio.aws.redshift.model.ClusterIamRole.ReadOnly]] = scala
      .Option(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterIamRole.wrap(item)
        }.toList
      )
    override val pendingActions: Option[List[String]] = scala
      .Option(impl.pendingActions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maintenanceTrackName: Option[String] =
      scala.Option(impl.maintenanceTrackName()).map(value => value: String)
    override val elasticResizeNumberOfNodeOptions: Option[String] = scala
      .Option(impl.elasticResizeNumberOfNodeOptions())
      .map(value => value: String)
    override val deferredMaintenanceWindows: Option[
      List[zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly]
    ] = scala
      .Option(impl.deferredMaintenanceWindows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.DeferredMaintenanceWindow.wrap(item)
        }.toList
      )
    override val snapshotScheduleIdentifier: Option[String] = scala
      .Option(impl.snapshotScheduleIdentifier())
      .map(value => value: String)
    override val snapshotScheduleState
        : Option[zio.aws.redshift.model.ScheduleState] = scala
      .Option(impl.snapshotScheduleState())
      .map(value => zio.aws.redshift.model.ScheduleState.wrap(value))
    override val expectedNextSnapshotScheduleTime: Option[TStamp] = scala
      .Option(impl.expectedNextSnapshotScheduleTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val expectedNextSnapshotScheduleTimeStatus: Option[String] = scala
      .Option(impl.expectedNextSnapshotScheduleTimeStatus())
      .map(value => value: String)
    override val nextMaintenanceWindowStartTime: Option[TStamp] = scala
      .Option(impl.nextMaintenanceWindowStartTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val resizeInfo
        : Option[zio.aws.redshift.model.ResizeInfo.ReadOnly] = scala
      .Option(impl.resizeInfo())
      .map(value => zio.aws.redshift.model.ResizeInfo.wrap(value))
    override val availabilityZoneRelocationStatus: Option[String] = scala
      .Option(impl.availabilityZoneRelocationStatus())
      .map(value => value: String)
    override val clusterNamespaceArn: Option[String] =
      scala.Option(impl.clusterNamespaceArn()).map(value => value: String)
    override val totalStorageCapacityInMegaBytes: Option[LongOptional] = scala
      .Option(impl.totalStorageCapacityInMegaBytes())
      .map(value => value: LongOptional)
    override val aquaConfiguration
        : Option[zio.aws.redshift.model.AquaConfiguration.ReadOnly] = scala
      .Option(impl.aquaConfiguration())
      .map(value => zio.aws.redshift.model.AquaConfiguration.wrap(value))
    override val defaultIamRoleArn: Option[String] =
      scala.Option(impl.defaultIamRoleArn()).map(value => value: String)
    override val reservedNodeExchangeStatus
        : Option[zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly] =
      scala
        .Option(impl.reservedNodeExchangeStatus())
        .map(value =>
          zio.aws.redshift.model.ReservedNodeExchangeStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Cluster
  ): zio.aws.redshift.model.Cluster.ReadOnly = new Wrapper(impl)
}
