package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RevokeEndpointAccessRequest(
    clusterIdentifier: Option[String] = None,
    account: Option[String] = None,
    vpcIds: Option[Iterable[String]] = None,
    force: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest = {
    import RevokeEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(account.map(value => value: java.lang.String))(_.account)
      .optionallyWith(
        vpcIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcIds)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RevokeEndpointAccessRequest.ReadOnly =
    zio.aws.redshift.model.RevokeEndpointAccessRequest.wrap(buildAwsValue())
}
object RevokeEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RevokeEndpointAccessRequest =
      zio.aws.redshift.model.RevokeEndpointAccessRequest(
        clusterIdentifier.map(value => value),
        account.map(value => value),
        vpcIds.map(value => value),
        force.map(value => value)
      )
    def clusterIdentifier: Option[String]
    def account: Option[String]
    def vpcIds: Option[List[String]]
    def force: Option[Boolean]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("account", account)
    def getVpcIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcIds", vpcIds)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest
  ) extends zio.aws.redshift.model.RevokeEndpointAccessRequest.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val account: Option[String] =
      scala.Option(impl.account()).map(value => value: String)
    override val vpcIds: Option[List[String]] = scala
      .Option(impl.vpcIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val force: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest
  ): zio.aws.redshift.model.RevokeEndpointAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
