package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait OperatorType {
  def unwrap: software.amazon.awssdk.services.redshift.model.OperatorType
}
object OperatorType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.OperatorType
  ): zio.aws.redshift.model.OperatorType = value match {
    case software.amazon.awssdk.services.redshift.model.OperatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.OperatorType.EQ =>
      val r = eq
      r
    case software.amazon.awssdk.services.redshift.model.OperatorType.LT =>
      val r = lt
      r
    case software.amazon.awssdk.services.redshift.model.OperatorType.GT =>
      val r = gt
      r
    case software.amazon.awssdk.services.redshift.model.OperatorType.LE =>
      val r = le
      r
    case software.amazon.awssdk.services.redshift.model.OperatorType.GE =>
      val r = ge
      r
    case software.amazon.awssdk.services.redshift.model.OperatorType.IN =>
      val r = in
      r
    case software.amazon.awssdk.services.redshift.model.OperatorType.BETWEEN =>
      val r = between
      r
  }
  case object unknownToSdkVersion extends zio.aws.redshift.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.OperatorType =
      software.amazon.awssdk.services.redshift.model.OperatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object eq extends zio.aws.redshift.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.OperatorType =
      software.amazon.awssdk.services.redshift.model.OperatorType.EQ
  }
  case object lt extends zio.aws.redshift.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.OperatorType =
      software.amazon.awssdk.services.redshift.model.OperatorType.LT
  }
  case object gt extends zio.aws.redshift.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.OperatorType =
      software.amazon.awssdk.services.redshift.model.OperatorType.GT
  }
  case object le extends zio.aws.redshift.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.OperatorType =
      software.amazon.awssdk.services.redshift.model.OperatorType.LE
  }
  case object ge extends zio.aws.redshift.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.OperatorType =
      software.amazon.awssdk.services.redshift.model.OperatorType.GE
  }
  case object in extends zio.aws.redshift.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.OperatorType =
      software.amazon.awssdk.services.redshift.model.OperatorType.IN
  }
  case object between extends zio.aws.redshift.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.OperatorType =
      software.amazon.awssdk.services.redshift.model.OperatorType.BETWEEN
  }
}
