package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateEventSubscriptionResponse(
    eventSubscription: Option[zio.aws.redshift.model.EventSubscription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse = {
    import CreateEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateEventSubscriptionResponse.ReadOnly =
    zio.aws.redshift.model.CreateEventSubscriptionResponse.wrap(buildAwsValue())
}
object CreateEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateEventSubscriptionResponse =
      zio.aws.redshift.model.CreateEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Option[zio.aws.redshift.model.EventSubscription.ReadOnly]
    def getEventSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.EventSubscription.ReadOnly
    ] = AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse
  ) extends zio.aws.redshift.model.CreateEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Option[zio.aws.redshift.model.EventSubscription.ReadOnly] = scala
      .Option(impl.eventSubscription())
      .map(value => zio.aws.redshift.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse
  ): zio.aws.redshift.model.CreateEventSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
