package zio.aws.redshift.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{
  IntegerOptional,
  TStamp,
  BooleanOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyClusterMaintenanceRequest(
    clusterIdentifier: String,
    deferMaintenance: Option[BooleanOptional] = None,
    deferMaintenanceIdentifier: Option[String] = None,
    deferMaintenanceStartTime: Option[TStamp] = None,
    deferMaintenanceEndTime: Option[TStamp] = None,
    deferMaintenanceDuration: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest = {
    import ModifyClusterMaintenanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(deferMaintenance.map(value => value: java.lang.Boolean))(
        _.deferMaintenance
      )
      .optionallyWith(
        deferMaintenanceIdentifier.map(value => value: java.lang.String)
      )(_.deferMaintenanceIdentifier)
      .optionallyWith(
        deferMaintenanceStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.deferMaintenanceStartTime)
      .optionallyWith(
        deferMaintenanceEndTime.map(value => TStamp.unwrap(value): Instant)
      )(_.deferMaintenanceEndTime)
      .optionallyWith(deferMaintenanceDuration.map(value => value: Integer))(
        _.deferMaintenanceDuration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterMaintenanceRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterMaintenanceRequest.wrap(buildAwsValue())
}
object ModifyClusterMaintenanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterMaintenanceRequest =
      zio.aws.redshift.model.ModifyClusterMaintenanceRequest(
        clusterIdentifier,
        deferMaintenance.map(value => value),
        deferMaintenanceIdentifier.map(value => value),
        deferMaintenanceStartTime.map(value => value),
        deferMaintenanceEndTime.map(value => value),
        deferMaintenanceDuration.map(value => value)
      )
    def clusterIdentifier: String
    def deferMaintenance: Option[BooleanOptional]
    def deferMaintenanceIdentifier: Option[String]
    def deferMaintenanceStartTime: Option[TStamp]
    def deferMaintenanceEndTime: Option[TStamp]
    def deferMaintenanceDuration: Option[IntegerOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getDeferMaintenance: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deferMaintenance", deferMaintenance)
    def getDeferMaintenanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "deferMaintenanceIdentifier",
        deferMaintenanceIdentifier
      )
    def getDeferMaintenanceStartTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("deferMaintenanceStartTime", deferMaintenanceStartTime)
    def getDeferMaintenanceEndTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("deferMaintenanceEndTime", deferMaintenanceEndTime)
    def getDeferMaintenanceDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "deferMaintenanceDuration",
        deferMaintenanceDuration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest
  ) extends zio.aws.redshift.model.ModifyClusterMaintenanceRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val deferMaintenance: Option[BooleanOptional] =
      scala.Option(impl.deferMaintenance()).map(value => value: BooleanOptional)
    override val deferMaintenanceIdentifier: Option[String] = scala
      .Option(impl.deferMaintenanceIdentifier())
      .map(value => value: String)
    override val deferMaintenanceStartTime: Option[TStamp] = scala
      .Option(impl.deferMaintenanceStartTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val deferMaintenanceEndTime: Option[TStamp] = scala
      .Option(impl.deferMaintenanceEndTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val deferMaintenanceDuration: Option[IntegerOptional] = scala
      .Option(impl.deferMaintenanceDuration())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest
  ): zio.aws.redshift.model.ModifyClusterMaintenanceRequest.ReadOnly =
    new Wrapper(impl)
}
