package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyClusterIamRolesResponse(
    cluster: Option[zio.aws.redshift.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse = {
    import ModifyClusterIamRolesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterIamRolesResponse.ReadOnly =
    zio.aws.redshift.model.ModifyClusterIamRolesResponse.wrap(buildAwsValue())
}
object ModifyClusterIamRolesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterIamRolesResponse =
      zio.aws.redshift.model
        .ModifyClusterIamRolesResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse
  ) extends zio.aws.redshift.model.ModifyClusterIamRolesResponse.ReadOnly {
    override val cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse
  ): zio.aws.redshift.model.ModifyClusterIamRolesResponse.ReadOnly =
    new Wrapper(impl)
}
