package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeStorageResponse(
    totalBackupSizeInMegaBytes: Option[Double] = None,
    totalProvisionedStorageInMegaBytes: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeStorageResponse = {
    import DescribeStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeStorageResponse
      .builder()
      .optionallyWith(
        totalBackupSizeInMegaBytes.map(value => value: java.lang.Double)
      )(_.totalBackupSizeInMegaBytes)
      .optionallyWith(
        totalProvisionedStorageInMegaBytes.map(value => value: java.lang.Double)
      )(_.totalProvisionedStorageInMegaBytes)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeStorageResponse.ReadOnly =
    zio.aws.redshift.model.DescribeStorageResponse.wrap(buildAwsValue())
}
object DescribeStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeStorageResponse =
      zio.aws.redshift.model.DescribeStorageResponse(
        totalBackupSizeInMegaBytes.map(value => value),
        totalProvisionedStorageInMegaBytes.map(value => value)
      )
    def totalBackupSizeInMegaBytes: Option[Double]
    def totalProvisionedStorageInMegaBytes: Option[Double]
    def getTotalBackupSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "totalBackupSizeInMegaBytes",
        totalBackupSizeInMegaBytes
      )
    def getTotalProvisionedStorageInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "totalProvisionedStorageInMegaBytes",
        totalProvisionedStorageInMegaBytes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeStorageResponse
  ) extends zio.aws.redshift.model.DescribeStorageResponse.ReadOnly {
    override val totalBackupSizeInMegaBytes: Option[Double] = scala
      .Option(impl.totalBackupSizeInMegaBytes())
      .map(value => value: Double)
    override val totalProvisionedStorageInMegaBytes: Option[Double] = scala
      .Option(impl.totalProvisionedStorageInMegaBytes())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeStorageResponse
  ): zio.aws.redshift.model.DescribeStorageResponse.ReadOnly = new Wrapper(impl)
}
