package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointAccessRequest(
    clusterIdentifier: Option[String] = None,
    resourceOwner: Option[String] = None,
    endpointName: Option[String] = None,
    vpcId: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest = {
    import DescribeEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .optionallyWith(endpointName.map(value => value: java.lang.String))(
        _.endpointName
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEndpointAccessRequest.ReadOnly =
    zio.aws.redshift.model.DescribeEndpointAccessRequest.wrap(buildAwsValue())
}
object DescribeEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeEndpointAccessRequest =
      zio.aws.redshift.model.DescribeEndpointAccessRequest(
        clusterIdentifier.map(value => value),
        resourceOwner.map(value => value),
        endpointName.map(value => value),
        vpcId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterIdentifier: Option[String]
    def resourceOwner: Option[String]
    def endpointName: Option[String]
    def vpcId: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
    def getEndpointName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest
  ) extends zio.aws.redshift.model.DescribeEndpointAccessRequest.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val resourceOwner: Option[String] =
      scala.Option(impl.resourceOwner()).map(value => value: String)
    override val endpointName: Option[String] =
      scala.Option(impl.endpointName()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest
  ): zio.aws.redshift.model.DescribeEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
