package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterTracksRequest(
    maintenanceTrackName: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest = {
    import DescribeClusterTracksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest
      .builder()
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeClusterTracksRequest.ReadOnly =
    zio.aws.redshift.model.DescribeClusterTracksRequest.wrap(buildAwsValue())
}
object DescribeClusterTracksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterTracksRequest =
      zio.aws.redshift.model.DescribeClusterTracksRequest(
        maintenanceTrackName.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def maintenanceTrackName: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest
  ) extends zio.aws.redshift.model.DescribeClusterTracksRequest.ReadOnly {
    override val maintenanceTrackName: Option[String] =
      scala.Option(impl.maintenanceTrackName()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest
  ): zio.aws.redshift.model.DescribeClusterTracksRequest.ReadOnly = new Wrapper(
    impl
  )
}
