package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.AuthenticationProfileNameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAuthenticationProfilesRequest(
    authenticationProfileName: Option[AuthenticationProfileNameString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest = {
    import DescribeAuthenticationProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest
      .builder()
      .optionallyWith(
        authenticationProfileName.map(value =>
          AuthenticationProfileNameString.unwrap(value): java.lang.String
        )
      )(_.authenticationProfileName)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeAuthenticationProfilesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeAuthenticationProfilesRequest
      .wrap(buildAwsValue())
}
object DescribeAuthenticationProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeAuthenticationProfilesRequest =
      zio.aws.redshift.model.DescribeAuthenticationProfilesRequest(
        authenticationProfileName.map(value => value)
      )
    def authenticationProfileName: Option[AuthenticationProfileNameString]
    def getAuthenticationProfileName
        : ZIO[Any, AwsError, AuthenticationProfileNameString] = AwsError
      .unwrapOptionField("authenticationProfileName", authenticationProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest
  ) extends zio.aws.redshift.model.DescribeAuthenticationProfilesRequest.ReadOnly {
    override val authenticationProfileName
        : Option[AuthenticationProfileNameString] = scala
      .Option(impl.authenticationProfileName())
      .map(value =>
        zio.aws.redshift.model.primitives.AuthenticationProfileNameString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest
  ): zio.aws.redshift.model.DescribeAuthenticationProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
