package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{LongOptional, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TableRestoreStatus(
    tableRestoreRequestId: Option[String] = None,
    status: Option[zio.aws.redshift.model.TableRestoreStatusType] = None,
    message: Option[String] = None,
    requestTime: Option[TStamp] = None,
    progressInMegaBytes: Option[LongOptional] = None,
    totalDataInMegaBytes: Option[LongOptional] = None,
    clusterIdentifier: Option[String] = None,
    snapshotIdentifier: Option[String] = None,
    sourceDatabaseName: Option[String] = None,
    sourceSchemaName: Option[String] = None,
    sourceTableName: Option[String] = None,
    targetDatabaseName: Option[String] = None,
    targetSchemaName: Option[String] = None,
    newTableName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.TableRestoreStatus = {
    import TableRestoreStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.TableRestoreStatus
      .builder()
      .optionallyWith(
        tableRestoreRequestId.map(value => value: java.lang.String)
      )(_.tableRestoreRequestId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(requestTime.map(value => TStamp.unwrap(value): Instant))(
        _.requestTime
      )
      .optionallyWith(progressInMegaBytes.map(value => value: java.lang.Long))(
        _.progressInMegaBytes
      )
      .optionallyWith(totalDataInMegaBytes.map(value => value: java.lang.Long))(
        _.totalDataInMegaBytes
      )
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(sourceDatabaseName.map(value => value: java.lang.String))(
        _.sourceDatabaseName
      )
      .optionallyWith(sourceSchemaName.map(value => value: java.lang.String))(
        _.sourceSchemaName
      )
      .optionallyWith(sourceTableName.map(value => value: java.lang.String))(
        _.sourceTableName
      )
      .optionallyWith(targetDatabaseName.map(value => value: java.lang.String))(
        _.targetDatabaseName
      )
      .optionallyWith(targetSchemaName.map(value => value: java.lang.String))(
        _.targetSchemaName
      )
      .optionallyWith(newTableName.map(value => value: java.lang.String))(
        _.newTableName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.TableRestoreStatus.ReadOnly =
    zio.aws.redshift.model.TableRestoreStatus.wrap(buildAwsValue())
}
object TableRestoreStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.TableRestoreStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.TableRestoreStatus =
      zio.aws.redshift.model.TableRestoreStatus(
        tableRestoreRequestId.map(value => value),
        status.map(value => value),
        message.map(value => value),
        requestTime.map(value => value),
        progressInMegaBytes.map(value => value),
        totalDataInMegaBytes.map(value => value),
        clusterIdentifier.map(value => value),
        snapshotIdentifier.map(value => value),
        sourceDatabaseName.map(value => value),
        sourceSchemaName.map(value => value),
        sourceTableName.map(value => value),
        targetDatabaseName.map(value => value),
        targetSchemaName.map(value => value),
        newTableName.map(value => value)
      )
    def tableRestoreRequestId: Option[String]
    def status: Option[zio.aws.redshift.model.TableRestoreStatusType]
    def message: Option[String]
    def requestTime: Option[TStamp]
    def progressInMegaBytes: Option[LongOptional]
    def totalDataInMegaBytes: Option[LongOptional]
    def clusterIdentifier: Option[String]
    def snapshotIdentifier: Option[String]
    def sourceDatabaseName: Option[String]
    def sourceSchemaName: Option[String]
    def sourceTableName: Option[String]
    def targetDatabaseName: Option[String]
    def targetSchemaName: Option[String]
    def newTableName: Option[String]
    def getTableRestoreRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableRestoreRequestId", tableRestoreRequestId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.TableRestoreStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getRequestTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getProgressInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("progressInMegaBytes", progressInMegaBytes)
    def getTotalDataInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("totalDataInMegaBytes", totalDataInMegaBytes)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getSourceDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDatabaseName", sourceDatabaseName)
    def getSourceSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceSchemaName", sourceSchemaName)
    def getSourceTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceTableName", sourceTableName)
    def getTargetDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetDatabaseName", targetDatabaseName)
    def getTargetSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetSchemaName", targetSchemaName)
    def getNewTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newTableName", newTableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.TableRestoreStatus
  ) extends zio.aws.redshift.model.TableRestoreStatus.ReadOnly {
    override val tableRestoreRequestId: Option[String] =
      scala.Option(impl.tableRestoreRequestId()).map(value => value: String)
    override val status: Option[zio.aws.redshift.model.TableRestoreStatusType] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.redshift.model.TableRestoreStatusType.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val requestTime: Option[TStamp] = scala
      .Option(impl.requestTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val progressInMegaBytes: Option[LongOptional] =
      scala.Option(impl.progressInMegaBytes()).map(value => value: LongOptional)
    override val totalDataInMegaBytes: Option[LongOptional] = scala
      .Option(impl.totalDataInMegaBytes())
      .map(value => value: LongOptional)
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val snapshotIdentifier: Option[String] =
      scala.Option(impl.snapshotIdentifier()).map(value => value: String)
    override val sourceDatabaseName: Option[String] =
      scala.Option(impl.sourceDatabaseName()).map(value => value: String)
    override val sourceSchemaName: Option[String] =
      scala.Option(impl.sourceSchemaName()).map(value => value: String)
    override val sourceTableName: Option[String] =
      scala.Option(impl.sourceTableName()).map(value => value: String)
    override val targetDatabaseName: Option[String] =
      scala.Option(impl.targetDatabaseName()).map(value => value: String)
    override val targetSchemaName: Option[String] =
      scala.Option(impl.targetSchemaName()).map(value => value: String)
    override val newTableName: Option[String] =
      scala.Option(impl.newTableName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.TableRestoreStatus
  ): zio.aws.redshift.model.TableRestoreStatus.ReadOnly = new Wrapper(impl)
}
