package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetClusterParameterGroupRequest(
    parameterGroupName: String,
    resetAllParameters: Option[Boolean] = None,
    parameters: Option[Iterable[zio.aws.redshift.model.Parameter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest = {
    import ResetClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(
        resetAllParameters.map(value => value: java.lang.Boolean)
      )(_.resetAllParameters)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ResetClusterParameterGroupRequest.ReadOnly =
    zio.aws.redshift.model.ResetClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object ResetClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResetClusterParameterGroupRequest =
      zio.aws.redshift.model.ResetClusterParameterGroupRequest(
        parameterGroupName,
        resetAllParameters.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterGroupName: String
    def resetAllParameters: Option[Boolean]
    def parameters: Option[List[zio.aws.redshift.model.Parameter.ReadOnly]]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getResetAllParameters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resetAllParameters", resetAllParameters)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest
  ) extends zio.aws.redshift.model.ResetClusterParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val resetAllParameters: Option[Boolean] =
      scala.Option(impl.resetAllParameters()).map(value => value: Boolean)
    override val parameters
        : Option[List[zio.aws.redshift.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest
  ): zio.aws.redshift.model.ResetClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
