package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateTarget(
    maintenanceTrackName: Option[String] = None,
    databaseVersion: Option[String] = None,
    supportedOperations: Option[
      Iterable[zio.aws.redshift.model.SupportedOperation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.UpdateTarget = {
    import UpdateTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.UpdateTarget
      .builder()
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(databaseVersion.map(value => value: java.lang.String))(
        _.databaseVersion
      )
      .optionallyWith(
        supportedOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedOperations)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.UpdateTarget.ReadOnly =
    zio.aws.redshift.model.UpdateTarget.wrap(buildAwsValue())
}
object UpdateTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.UpdateTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.UpdateTarget =
      zio.aws.redshift.model.UpdateTarget(
        maintenanceTrackName.map(value => value),
        databaseVersion.map(value => value),
        supportedOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maintenanceTrackName: Option[String]
    def databaseVersion: Option[String]
    def supportedOperations
        : Option[List[zio.aws.redshift.model.SupportedOperation.ReadOnly]]
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getDatabaseVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseVersion", databaseVersion)
    def getSupportedOperations: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SupportedOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("supportedOperations", supportedOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.UpdateTarget
  ) extends zio.aws.redshift.model.UpdateTarget.ReadOnly {
    override val maintenanceTrackName: Option[String] =
      scala.Option(impl.maintenanceTrackName()).map(value => value: String)
    override val databaseVersion: Option[String] =
      scala.Option(impl.databaseVersion()).map(value => value: String)
    override val supportedOperations
        : Option[List[zio.aws.redshift.model.SupportedOperation.ReadOnly]] =
      scala
        .Option(impl.supportedOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.SupportedOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.UpdateTarget
  ): zio.aws.redshift.model.UpdateTarget.ReadOnly = new Wrapper(impl)
}
