package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{TStamp, SensitiveString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetClusterCredentialsResponse(
    dbUser: Option[String] = None,
    dbPassword: Option[SensitiveString] = None,
    expiration: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse = {
    import GetClusterCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse
      .builder()
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(
        dbPassword.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.dbPassword)
      .optionallyWith(expiration.map(value => TStamp.unwrap(value): Instant))(
        _.expiration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly =
    zio.aws.redshift.model.GetClusterCredentialsResponse.wrap(buildAwsValue())
}
object GetClusterCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.GetClusterCredentialsResponse =
      zio.aws.redshift.model.GetClusterCredentialsResponse(
        dbUser.map(value => value),
        dbPassword.map(value => value),
        expiration.map(value => value)
      )
    def dbUser: Option[String]
    def dbPassword: Option[SensitiveString]
    def expiration: Option[TStamp]
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getDbPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("dbPassword", dbPassword)
    def getExpiration: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse
  ) extends zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly {
    override val dbUser: Option[String] =
      scala.Option(impl.dbUser()).map(value => value: String)
    override val dbPassword: Option[SensitiveString] = scala
      .Option(impl.dbPassword())
      .map(value => zio.aws.redshift.model.primitives.SensitiveString(value))
    override val expiration: Option[TStamp] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse
  ): zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
