package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PendingModifiedValues(
    masterUserPassword: Option[String] = None,
    nodeType: Option[String] = None,
    numberOfNodes: Option[IntegerOptional] = None,
    clusterType: Option[String] = None,
    clusterVersion: Option[String] = None,
    automatedSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    clusterIdentifier: Option[String] = None,
    publiclyAccessible: Option[BooleanOptional] = None,
    enhancedVpcRouting: Option[BooleanOptional] = None,
    maintenanceTrackName: Option[String] = None,
    encryptionType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PendingModifiedValues
      .builder()
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(encryptionType.map(value => value: java.lang.String))(
        _.encryptionType
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.PendingModifiedValues.ReadOnly =
    zio.aws.redshift.model.PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.PendingModifiedValues =
      zio.aws.redshift.model.PendingModifiedValues(
        masterUserPassword.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        clusterType.map(value => value),
        clusterVersion.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        clusterIdentifier.map(value => value),
        publiclyAccessible.map(value => value),
        enhancedVpcRouting.map(value => value),
        maintenanceTrackName.map(value => value),
        encryptionType.map(value => value)
      )
    def masterUserPassword: Option[String]
    def nodeType: Option[String]
    def numberOfNodes: Option[IntegerOptional]
    def clusterType: Option[String]
    def clusterVersion: Option[String]
    def automatedSnapshotRetentionPeriod: Option[IntegerOptional]
    def clusterIdentifier: Option[String]
    def publiclyAccessible: Option[BooleanOptional]
    def enhancedVpcRouting: Option[BooleanOptional]
    def maintenanceTrackName: Option[String]
    def encryptionType: Option[String]
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getAutomatedSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "automatedSnapshotRetentionPeriod",
      automatedSnapshotRetentionPeriod
    )
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getEncryptionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PendingModifiedValues
  ) extends zio.aws.redshift.model.PendingModifiedValues.ReadOnly {
    override val masterUserPassword: Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val numberOfNodes: Option[IntegerOptional] =
      scala.Option(impl.numberOfNodes()).map(value => value: IntegerOptional)
    override val clusterType: Option[String] =
      scala.Option(impl.clusterType()).map(value => value: String)
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val automatedSnapshotRetentionPeriod: Option[IntegerOptional] =
      scala
        .Option(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val publiclyAccessible: Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => value: BooleanOptional)
    override val enhancedVpcRouting: Option[BooleanOptional] = scala
      .Option(impl.enhancedVpcRouting())
      .map(value => value: BooleanOptional)
    override val maintenanceTrackName: Option[String] =
      scala.Option(impl.maintenanceTrackName()).map(value => value: String)
    override val encryptionType: Option[String] =
      scala.Option(impl.encryptionType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PendingModifiedValues
  ): zio.aws.redshift.model.PendingModifiedValues.ReadOnly = new Wrapper(impl)
}
