package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ElasticIpStatus(
    elasticIp: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ElasticIpStatus = {
    import ElasticIpStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ElasticIpStatus
      .builder()
      .optionallyWith(elasticIp.map(value => value: java.lang.String))(
        _.elasticIp
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ElasticIpStatus.ReadOnly =
    zio.aws.redshift.model.ElasticIpStatus.wrap(buildAwsValue())
}
object ElasticIpStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ElasticIpStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ElasticIpStatus =
      zio.aws.redshift.model.ElasticIpStatus(
        elasticIp.map(value => value),
        status.map(value => value)
      )
    def elasticIp: Option[String]
    def status: Option[String]
    def getElasticIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticIp", elasticIp)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ElasticIpStatus
  ) extends zio.aws.redshift.model.ElasticIpStatus.ReadOnly {
    override val elasticIp: Option[String] =
      scala.Option(impl.elasticIp()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ElasticIpStatus
  ): zio.aws.redshift.model.ElasticIpStatus.ReadOnly = new Wrapper(impl)
}
