package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDataSharesForProducerResponse(
    dataShares: Option[Iterable[zio.aws.redshift.model.DataShare]] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse = {
    import DescribeDataSharesForProducerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse
      .builder()
      .optionallyWith(
        dataShares.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataShares)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeDataSharesForProducerResponse.ReadOnly =
    zio.aws.redshift.model.DescribeDataSharesForProducerResponse
      .wrap(buildAwsValue())
}
object DescribeDataSharesForProducerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeDataSharesForProducerResponse =
      zio.aws.redshift.model.DescribeDataSharesForProducerResponse(
        dataShares.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def dataShares: Option[List[zio.aws.redshift.model.DataShare.ReadOnly]]
    def marker: Option[String]
    def getDataShares
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.DataShare.ReadOnly]] =
      AwsError.unwrapOptionField("dataShares", dataShares)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse
  ) extends zio.aws.redshift.model.DescribeDataSharesForProducerResponse.ReadOnly {
    override val dataShares
        : Option[List[zio.aws.redshift.model.DataShare.ReadOnly]] = scala
      .Option(impl.dataShares())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.DataShare.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse
  ): zio.aws.redshift.model.DescribeDataSharesForProducerResponse.ReadOnly =
    new Wrapper(impl)
}
