package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetClusterParameterGroupResponse(
    parameterGroupName: Option[String] = None,
    parameterGroupStatus: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse = {
    import ResetClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterGroupStatus.map(value => value: java.lang.String)
      )(_.parameterGroupStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ResetClusterParameterGroupResponse.ReadOnly =
    zio.aws.redshift.model.ResetClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object ResetClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResetClusterParameterGroupResponse =
      zio.aws.redshift.model.ResetClusterParameterGroupResponse(
        parameterGroupName.map(value => value),
        parameterGroupStatus.map(value => value)
      )
    def parameterGroupName: Option[String]
    def parameterGroupStatus: Option[String]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupStatus", parameterGroupStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse
  ) extends zio.aws.redshift.model.ResetClusterParameterGroupResponse.ReadOnly {
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val parameterGroupStatus: Option[String] =
      scala.Option(impl.parameterGroupStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse
  ): zio.aws.redshift.model.ResetClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
