package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDataSharesForConsumerRequest(
    consumerArn: Option[String] = None,
    status: Option[zio.aws.redshift.model.DataShareStatusForConsumer] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest = {
    import DescribeDataSharesForConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest
      .builder()
      .optionallyWith(consumerArn.map(value => value: java.lang.String))(
        _.consumerArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeDataSharesForConsumerRequest.ReadOnly =
    zio.aws.redshift.model.DescribeDataSharesForConsumerRequest
      .wrap(buildAwsValue())
}
object DescribeDataSharesForConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeDataSharesForConsumerRequest =
      zio.aws.redshift.model.DescribeDataSharesForConsumerRequest(
        consumerArn.map(value => value),
        status.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def consumerArn: Option[String]
    def status: Option[zio.aws.redshift.model.DataShareStatusForConsumer]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getConsumerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerArn", consumerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.DataShareStatusForConsumer
    ] = AwsError.unwrapOptionField("status", status)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest
  ) extends zio.aws.redshift.model.DescribeDataSharesForConsumerRequest.ReadOnly {
    override val consumerArn: Option[String] =
      scala.Option(impl.consumerArn()).map(value => value: String)
    override val status
        : Option[zio.aws.redshift.model.DataShareStatusForConsumer] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.redshift.model.DataShareStatusForConsumer.wrap(value)
      )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest
  ): zio.aws.redshift.model.DescribeDataSharesForConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
