package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteClusterParameterGroupRequest(
    parameterGroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest = {
    import DeleteClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DeleteClusterParameterGroupRequest.ReadOnly =
    zio.aws.redshift.model.DeleteClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object DeleteClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteClusterParameterGroupRequest =
      zio.aws.redshift.model
        .DeleteClusterParameterGroupRequest(parameterGroupName)
    def parameterGroupName: String
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest
  ) extends zio.aws.redshift.model.DeleteClusterParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest
  ): zio.aws.redshift.model.DeleteClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
