package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EventCategoriesMap(
    sourceType: Option[String] = None,
    events: Option[Iterable[zio.aws.redshift.model.EventInfoMap]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EventCategoriesMap = {
    import EventCategoriesMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EventCategoriesMap
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EventCategoriesMap.ReadOnly =
    zio.aws.redshift.model.EventCategoriesMap.wrap(buildAwsValue())
}
object EventCategoriesMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EventCategoriesMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EventCategoriesMap =
      zio.aws.redshift.model.EventCategoriesMap(
        sourceType.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceType: Option[String]
    def events: Option[List[zio.aws.redshift.model.EventInfoMap.ReadOnly]]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.EventInfoMap.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EventCategoriesMap
  ) extends zio.aws.redshift.model.EventCategoriesMap.ReadOnly {
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val events
        : Option[List[zio.aws.redshift.model.EventInfoMap.ReadOnly]] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.EventInfoMap.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EventCategoriesMap
  ): zio.aws.redshift.model.EventCategoriesMap.ReadOnly = new Wrapper(impl)
}
