package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Endpoint(
    address: Option[String] = None,
    port: Option[Integer] = None,
    vpcEndpoints: Option[Iterable[zio.aws.redshift.model.VpcEndpoint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Endpoint
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        vpcEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcEndpoints)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Endpoint.ReadOnly =
    zio.aws.redshift.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Endpoint =
      zio.aws.redshift.model.Endpoint(
        address.map(value => value),
        port.map(value => value),
        vpcEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def address: Option[String]
    def port: Option[Integer]
    def vpcEndpoints: Option[List[zio.aws.redshift.model.VpcEndpoint.ReadOnly]]
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getVpcEndpoints: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.VpcEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcEndpoints", vpcEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Endpoint
  ) extends zio.aws.redshift.model.Endpoint.ReadOnly {
    override val address: Option[String] =
      scala.Option(impl.address()).map(value => value: String)
    override val port: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val vpcEndpoints
        : Option[List[zio.aws.redshift.model.VpcEndpoint.ReadOnly]] = scala
      .Option(impl.vpcEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.VpcEndpoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Endpoint
  ): zio.aws.redshift.model.Endpoint.ReadOnly = new Wrapper(impl)
}
