package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DisassociateDataShareConsumerRequest(
    dataShareArn: String,
    disassociateEntireAccount: Option[BooleanOptional] = None,
    consumerArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest = {
    import DisassociateDataShareConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest
      .builder()
      .dataShareArn(dataShareArn: java.lang.String)
      .optionallyWith(
        disassociateEntireAccount.map(value => value: java.lang.Boolean)
      )(_.disassociateEntireAccount)
      .optionallyWith(consumerArn.map(value => value: java.lang.String))(
        _.consumerArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DisassociateDataShareConsumerRequest.ReadOnly =
    zio.aws.redshift.model.DisassociateDataShareConsumerRequest
      .wrap(buildAwsValue())
}
object DisassociateDataShareConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DisassociateDataShareConsumerRequest =
      zio.aws.redshift.model.DisassociateDataShareConsumerRequest(
        dataShareArn,
        disassociateEntireAccount.map(value => value),
        consumerArn.map(value => value)
      )
    def dataShareArn: String
    def disassociateEntireAccount: Option[BooleanOptional]
    def consumerArn: Option[String]
    def getDataShareArn: ZIO[Any, Nothing, String] = ZIO.succeed(dataShareArn)
    def getDisassociateEntireAccount: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "disassociateEntireAccount",
        disassociateEntireAccount
      )
    def getConsumerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerArn", consumerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest
  ) extends zio.aws.redshift.model.DisassociateDataShareConsumerRequest.ReadOnly {
    override val dataShareArn: String = impl.dataShareArn(): String
    override val disassociateEntireAccount: Option[BooleanOptional] = scala
      .Option(impl.disassociateEntireAccount())
      .map(value => value: BooleanOptional)
    override val consumerArn: Option[String] =
      scala.Option(impl.consumerArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest
  ): zio.aws.redshift.model.DisassociateDataShareConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
