package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DefaultClusterParameters(
    parameterGroupFamily: Option[String] = None,
    marker: Option[String] = None,
    parameters: Option[Iterable[zio.aws.redshift.model.Parameter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DefaultClusterParameters = {
    import DefaultClusterParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DefaultClusterParameters
      .builder()
      .optionallyWith(
        parameterGroupFamily.map(value => value: java.lang.String)
      )(_.parameterGroupFamily)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DefaultClusterParameters.ReadOnly =
    zio.aws.redshift.model.DefaultClusterParameters.wrap(buildAwsValue())
}
object DefaultClusterParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DefaultClusterParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DefaultClusterParameters =
      zio.aws.redshift.model.DefaultClusterParameters(
        parameterGroupFamily.map(value => value),
        marker.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterGroupFamily: Option[String]
    def marker: Option[String]
    def parameters: Option[List[zio.aws.redshift.model.Parameter.ReadOnly]]
    def getParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupFamily", parameterGroupFamily)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DefaultClusterParameters
  ) extends zio.aws.redshift.model.DefaultClusterParameters.ReadOnly {
    override val parameterGroupFamily: Option[String] =
      scala.Option(impl.parameterGroupFamily()).map(value => value: String)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val parameters
        : Option[List[zio.aws.redshift.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DefaultClusterParameters
  ): zio.aws.redshift.model.DefaultClusterParameters.ReadOnly = new Wrapper(
    impl
  )
}
