package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{BooleanOptional, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateScheduledActionRequest(
    scheduledActionName: String,
    targetAction: zio.aws.redshift.model.ScheduledActionType,
    schedule: String,
    iamRole: String,
    scheduledActionDescription: Option[String] = None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None,
    enable: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest = {
    import CreateScheduledActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest
      .builder()
      .scheduledActionName(scheduledActionName: java.lang.String)
      .targetAction(targetAction.buildAwsValue())
      .schedule(schedule: java.lang.String)
      .iamRole(iamRole: java.lang.String)
      .optionallyWith(
        scheduledActionDescription.map(value => value: java.lang.String)
      )(_.scheduledActionDescription)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(enable.map(value => value: java.lang.Boolean))(_.enable)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateScheduledActionRequest.ReadOnly =
    zio.aws.redshift.model.CreateScheduledActionRequest.wrap(buildAwsValue())
}
object CreateScheduledActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateScheduledActionRequest =
      zio.aws.redshift.model.CreateScheduledActionRequest(
        scheduledActionName,
        targetAction.asEditable,
        schedule,
        iamRole,
        scheduledActionDescription.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        enable.map(value => value)
      )
    def scheduledActionName: String
    def targetAction: zio.aws.redshift.model.ScheduledActionType.ReadOnly
    def schedule: String
    def iamRole: String
    def scheduledActionDescription: Option[String]
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def enable: Option[BooleanOptional]
    def getScheduledActionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(scheduledActionName)
    def getTargetAction: ZIO[
      Any,
      Nothing,
      zio.aws.redshift.model.ScheduledActionType.ReadOnly
    ] = ZIO.succeed(targetAction)
    def getSchedule: ZIO[Any, Nothing, String] = ZIO.succeed(schedule)
    def getIamRole: ZIO[Any, Nothing, String] = ZIO.succeed(iamRole)
    def getScheduledActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "scheduledActionDescription",
        scheduledActionDescription
      )
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getEnable: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enable", enable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest
  ) extends zio.aws.redshift.model.CreateScheduledActionRequest.ReadOnly {
    override val scheduledActionName: String =
      impl.scheduledActionName(): String
    override val targetAction
        : zio.aws.redshift.model.ScheduledActionType.ReadOnly =
      zio.aws.redshift.model.ScheduledActionType.wrap(impl.targetAction())
    override val schedule: String = impl.schedule(): String
    override val iamRole: String = impl.iamRole(): String
    override val scheduledActionDescription: Option[String] = scala
      .Option(impl.scheduledActionDescription())
      .map(value => value: String)
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val enable: Option[BooleanOptional] =
      scala.Option(impl.enable()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest
  ): zio.aws.redshift.model.CreateScheduledActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
