package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{BooleanOptional, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ModifyScheduledActionRequest(
    scheduledActionName: String,
    targetAction: Option[zio.aws.redshift.model.ScheduledActionType] = None,
    schedule: Option[String] = None,
    iamRole: Option[String] = None,
    scheduledActionDescription: Option[String] = None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None,
    enable: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest = {
    import ModifyScheduledActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest
      .builder()
      .scheduledActionName(scheduledActionName: java.lang.String)
      .optionallyWith(targetAction.map(value => value.buildAwsValue()))(
        _.targetAction
      )
      .optionallyWith(schedule.map(value => value: java.lang.String))(
        _.schedule
      )
      .optionallyWith(iamRole.map(value => value: java.lang.String))(_.iamRole)
      .optionallyWith(
        scheduledActionDescription.map(value => value: java.lang.String)
      )(_.scheduledActionDescription)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        enable.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.enable)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyScheduledActionRequest.ReadOnly =
    zio.aws.redshift.model.ModifyScheduledActionRequest.wrap(buildAwsValue())
}
object ModifyScheduledActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyScheduledActionRequest =
      zio.aws.redshift.model.ModifyScheduledActionRequest(
        scheduledActionName,
        targetAction.map(value => value.asEditable),
        schedule.map(value => value),
        iamRole.map(value => value),
        scheduledActionDescription.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        enable.map(value => value)
      )
    def scheduledActionName: String
    def targetAction
        : Option[zio.aws.redshift.model.ScheduledActionType.ReadOnly]
    def schedule: Option[String]
    def iamRole: Option[String]
    def scheduledActionDescription: Option[String]
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def enable: Option[BooleanOptional]
    def getScheduledActionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(scheduledActionName)
    def getTargetAction: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ScheduledActionType.ReadOnly
    ] = AwsError.unwrapOptionField("targetAction", targetAction)
    def getSchedule: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getIamRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getScheduledActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "scheduledActionDescription",
        scheduledActionDescription
      )
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getEnable: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enable", enable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest
  ) extends zio.aws.redshift.model.ModifyScheduledActionRequest.ReadOnly {
    override val scheduledActionName: String =
      impl.scheduledActionName(): String
    override val targetAction
        : Option[zio.aws.redshift.model.ScheduledActionType.ReadOnly] = scala
      .Option(impl.targetAction())
      .map(value => zio.aws.redshift.model.ScheduledActionType.wrap(value))
    override val schedule: Option[String] =
      scala.Option(impl.schedule()).map(value => value: String)
    override val iamRole: Option[String] =
      scala.Option(impl.iamRole()).map(value => value: String)
    override val scheduledActionDescription: Option[String] = scala
      .Option(impl.scheduledActionDescription())
      .map(value => value: String)
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val enable: Option[BooleanOptional] = scala
      .Option(impl.enable())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest
  ): zio.aws.redshift.model.ModifyScheduledActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
