package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDataSharesForProducerRequest(
    producerArn: Option[String] = None,
    status: Option[zio.aws.redshift.model.DataShareStatusForProducer] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest = {
    import DescribeDataSharesForProducerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest
      .builder()
      .optionallyWith(producerArn.map(value => value: java.lang.String))(
        _.producerArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeDataSharesForProducerRequest.ReadOnly =
    zio.aws.redshift.model.DescribeDataSharesForProducerRequest
      .wrap(buildAwsValue())
}
object DescribeDataSharesForProducerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeDataSharesForProducerRequest =
      zio.aws.redshift.model.DescribeDataSharesForProducerRequest(
        producerArn.map(value => value),
        status.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def producerArn: Option[String]
    def status: Option[zio.aws.redshift.model.DataShareStatusForProducer]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getProducerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("producerArn", producerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.DataShareStatusForProducer
    ] = AwsError.unwrapOptionField("status", status)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest
  ) extends zio.aws.redshift.model.DescribeDataSharesForProducerRequest.ReadOnly {
    override val producerArn: Option[String] =
      scala.Option(impl.producerArn()).map(value => value: String)
    override val status
        : Option[zio.aws.redshift.model.DataShareStatusForProducer] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.redshift.model.DataShareStatusForProducer.wrap(value)
      )
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest
  ): zio.aws.redshift.model.DescribeDataSharesForProducerRequest.ReadOnly =
    new Wrapper(impl)
}
