package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Parameter(
    parameterName: Option[String] = None,
    parameterValue: Option[String] = None,
    description: Option[String] = None,
    source: Option[String] = None,
    dataType: Option[String] = None,
    allowedValues: Option[String] = None,
    applyType: Option[zio.aws.redshift.model.ParameterApplyType] = None,
    isModifiable: Option[Boolean] = None,
    minimumEngineVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Parameter
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(applyType.map(value => value.unwrap))(_.applyType)
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Parameter.ReadOnly =
    zio.aws.redshift.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.Parameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Parameter =
      zio.aws.redshift.model.Parameter(
        parameterName.map(value => value),
        parameterValue.map(value => value),
        description.map(value => value),
        source.map(value => value),
        dataType.map(value => value),
        allowedValues.map(value => value),
        applyType.map(value => value),
        isModifiable.map(value => value),
        minimumEngineVersion.map(value => value)
      )
    def parameterName: Option[String]
    def parameterValue: Option[String]
    def description: Option[String]
    def source: Option[String]
    def dataType: Option[String]
    def allowedValues: Option[String]
    def applyType: Option[zio.aws.redshift.model.ParameterApplyType]
    def isModifiable: Option[Boolean]
    def minimumEngineVersion: Option[String]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getApplyType
        : ZIO[Any, AwsError, zio.aws.redshift.model.ParameterApplyType] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Parameter
  ) extends zio.aws.redshift.model.Parameter.ReadOnly {
    override val parameterName: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override val parameterValue: Option[String] =
      scala.Option(impl.parameterValue()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val dataType: Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override val allowedValues: Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override val applyType: Option[zio.aws.redshift.model.ParameterApplyType] =
      scala
        .Option(impl.applyType())
        .map(value => zio.aws.redshift.model.ParameterApplyType.wrap(value))
    override val isModifiable: Option[Boolean] =
      scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override val minimumEngineVersion: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Parameter
  ): zio.aws.redshift.model.Parameter.ReadOnly = new Wrapper(impl)
}
