package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterDbRevisionsResponse(
    marker: Option[String] = None,
    clusterDbRevisions: Option[
      Iterable[zio.aws.redshift.model.ClusterDbRevision]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse = {
    import DescribeClusterDbRevisionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        clusterDbRevisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterDbRevisions)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterDbRevisionsResponse
      .wrap(buildAwsValue())
}
object DescribeClusterDbRevisionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterDbRevisionsResponse =
      zio.aws.redshift.model.DescribeClusterDbRevisionsResponse(
        marker.map(value => value),
        clusterDbRevisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def clusterDbRevisions
        : Option[List[zio.aws.redshift.model.ClusterDbRevision.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getClusterDbRevisions: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterDbRevision.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterDbRevisions", clusterDbRevisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse
  ) extends zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val clusterDbRevisions
        : Option[List[zio.aws.redshift.model.ClusterDbRevision.ReadOnly]] =
      scala
        .Option(impl.clusterDbRevisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ClusterDbRevision.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse
  ): zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.ReadOnly =
    new Wrapper(impl)
}
