package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterSubnetGroupRequest(
    clusterSubnetGroupName: String,
    description: String,
    subnetIds: Iterable[String],
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest = {
    import CreateClusterSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest
      .builder()
      .clusterSubnetGroupName(clusterSubnetGroupName: java.lang.String)
      .description(description: java.lang.String)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateClusterSubnetGroupRequest.ReadOnly =
    zio.aws.redshift.model.CreateClusterSubnetGroupRequest.wrap(buildAwsValue())
}
object CreateClusterSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterSubnetGroupRequest =
      zio.aws.redshift.model.CreateClusterSubnetGroupRequest(
        clusterSubnetGroupName,
        description,
        subnetIds,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterSubnetGroupName: String
    def description: String
    def subnetIds: List[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getClusterSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterSubnetGroupName)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest
  ) extends zio.aws.redshift.model.CreateClusterSubnetGroupRequest.ReadOnly {
    override val clusterSubnetGroupName: String =
      impl.clusterSubnetGroupName(): String
    override val description: String = impl.description(): String
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest
  ): zio.aws.redshift.model.CreateClusterSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
